<script type="text/html" id="tmpl-ag-region">
    <li class="ag-region">
        <input type="hidden" name="ag_settings[region][{{data.key}}][type]" data-key="type" value="{{data.set}}" />
        <div class="ag-region__handle">
            <span class="dashicons dashicons-editor-justify"></span>
        </div>
        <div class="ag-region__field-group">
            <div>
                <label class="ag-region__label"><?php _e('Region name', 'age-gate-region'); ?></label>
                <input type="text" name="ag_settings[region][{{data.key}}][title]" data-key="title" class="regular-text ltr ag-region__field ag-region__field--title" value="{{data.name}}" required />
            </div>
            <?php if ($languages) : ?>
                <button class="ag-region__translation-toggle button-link" type="button"><?php _e('Translations', 'age-gate-region'); ?></button>
                <div class="ag-region__translations">
                    <p><small><?php _e('Translations are not required. Default name will be used.', 'age-gate-region'); ?></small></p>
                    <?php foreach ($languages['available'] as $language) : ?>
                        <div class="ag-region__translation">
                            <img src="<?=$language['flag'] ?>">
                            <input type="text" name="ag_settings[region][{{data.key}}][title_<?=$language['code'] ?>]" class="regular-text ltr ag-region__field ag-region__field--title ag-region__field--title--lang" value="" />
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="ag-region__field-group">
            <label class="ag-region__label"><?php _e('Region code', 'age-gate-region'); ?></label>
            <input type="text" name="ag_settings[region][{{data.key}}][code]" data-key="code" class="small-text ltr ag-region__code" value="{{data.code}}" required />
        </div>
        <div class="ag-region__field-group">
            <label class="ag-region__label"><?php _e('Restriction age', 'age-gate-region'); ?></label>
            <input type="number" name="ag_settings[region][{{data.key}}][age]" data-key="age" class="small-text ltr" value="{{data.age}}" required />
        </div>
        <div class="ag-region__field-group">
            <label class="ag-region__label"><?php _e('Redirect on success', 'age-gate-region'); ?></label>
            <select name="ag_settings[region][{{data.key}}][redirect]" data-key="redirect" class="regular-text ltr ag-redirect-type">
                <option value="" selected><?php _e('Current page', 'age-gate-region'); ?></option>
                {{{ data.redirectOptions }}}
                <option value="custom"><?php _e('Custom', 'age-gate-region'); ?></option>
            </select>

            <div class="ag-region__subfield hidden">
                <label class="ag-region__label"><?php _e('Custom redirect URL', 'age-gate-region'); ?></label>
                <input type="url" name="ag_settings[region][{{data.key}}][custom_redirect]" data-key="custom_redirect" class="regular-text ltr ag-region__custom" value="" disabled required />
            </div>
        </div>
        <div class="ag-region__field ag-region__field--checkbox">
            <label class="ag-region__label"><input type="checkbox" name="ag_settings[region][{{data.key}}][default]" class="ag-region__default" value="1" /> <?php _e('Set as default', 'age-gate-region'); ?></label>
        </div>
        <div class="ag-region__actions">
            <button type="button" class="ag-region__action ag-region__action--remove"><span class="dashicons dashicons-remove"></span></button>
            <?php /*
            <button type="button" class="ag-region__action ag-region__action--children"><span class="dashicons dashicons-download"></span></button>
            */ ?>
        </div>
    </li>
</script>
<script type="text/html" id="tmpl-ag-region-placeholder">
    <li class="ag-region-placeholder">
        <button type="button" class="ag-region__action ag-region__action--add"><?php _e('Add region', 'age-gate-region'); ?></button>
    </li>
</script>
